package gov.va.med.mhv.admin.dto;

import java.io.Serializable;
import java.util.Date;

public class MVI1305SearchDTO implements Serializable {

	private static final long serialVersionUID = -7754752017017494494L;
	
	private Long userId = null;
	private String firstName = null;
	private String middleName = null;
	private String lastName = null;
	private String prefix = null;
	private String suffix = null;
	private String gender = null;
	private String ssn = null;
	private Date birthDate = null;
	private String homePhone = null;
	private String birthCity = null;
	private String birthState = null;
	private String birthCountry = null;
	private String mothersMaidenName = null;
	private String[] addressStreets = null;
	private String addressCity = null;
	private String addressState = null;
	private String addressZip = null;
	private String addressCountry = null;
	private String icn = null;
	
	private boolean useIcnOnly = false;

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getMiddleName() {
		return middleName;
	}

	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getNamePrefix() {
		return prefix;
	}

	public void setNamePrefix(String prefix) {
		this.prefix = prefix;
	}

	public String getNameSuffix() {
		return suffix;
	}

	public void setNameSuffix(String suffix) {
		this.suffix = suffix;
	}


	/**
	 * @param defaultStr
	 *            The <code>String</code> value that will returned if first
	 *            name, middle name, and last name, etc. are all <code>null</code>.
	 * @return The full name in this format: firstname middlename lastname.
	 */
	public String getDisplayName(String defaultStr) {
		StringBuilder fullName = new StringBuilder();

		if (this.firstName != null) {
			fullName.append(this.firstName);
		}
		
		if (fullName.length() == 0 && this.middleName != null) {
			fullName.append(this.middleName);
		}
		else if (this.middleName != null) {
			fullName.append(" " + this.middleName);
		}
		
		if (fullName.length() == 0 && this.lastName != null) {
			fullName.append(this.lastName);
		}
		else if (this.lastName != null) {
			fullName.append(" " + this.lastName);
		}
		if (fullName.length() > 0) {
			return fullName.toString();
		}
		return defaultStr;
	}

	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}

	public String getIcn() {
		return icn;
	}

	public void setIcn(String icn) {
		this.icn = icn;
	}
	
	public boolean getUseIcnOnly() {
		return useIcnOnly;
	}

	public void setUseIcnOnly(boolean useIcnOnly) {
		this.useIcnOnly = useIcnOnly;
	}
	
	public String getSsn() {
		return ssn;
	}

	public void setSsn(String ssn) {
		this.ssn = ssn;
	}
	
	public Date getBirthDate() {
		return birthDate;
	}

	public void setBirthDate(Date birthDate) {
		this.birthDate = birthDate;
	}

	public String getHomePhone() {
		return homePhone;
	}

	public void setHomePhone(String homePhone) {
		this.homePhone = homePhone;
	}

	public String getBirthCity() {
		return birthCity;
	}

	public void setBirthCity(String birthCity) {
		this.birthCity = birthCity;
	}

	public String getBirthState() {
		return birthState;
	}

	public void setBirthState(String birthState) {
		this.birthState = birthState;
	}

	public String getBirthCountry() {
		return birthCountry;
	}

	public void setBirthCountry(String birthCountry) {
		this.birthCountry = birthCountry;
	}

	public String getMothersMaidenName() {
		return mothersMaidenName;
	}

	public void setMothersMaidenName(String mothersMaidenName) {
		this.mothersMaidenName = mothersMaidenName;
	}

	public String[] getAddressStreets() {
		return addressStreets;
	}

	public void setAddressStreets(String[] addressStreets) {
		this.addressStreets = addressStreets;
	}

	public String getAddressCity() {
		return addressCity;
	}

	public void setAddressCity(String addressCity) {
		this.addressCity = addressCity;
	}

	public String getAddressState() {
		return addressState;
	}

	public void setAddressState(String addressState) {
		this.addressState = addressState;
	}

	public String getAddressZip() {
		return addressZip;
	}

	public void setAddressZip(String addressZip) {
		this.addressZip = addressZip;
	}

	public String getAddressCountry() {
		return addressCountry;
	}

	public void setAddressCountry(String addressCountry) {
		this.addressCountry = addressCountry;
	}

}
